#delimit ;

capture log close;

* some stuff to make it easier to work between PC and UNIX;

* and some other stuff to make the program run only waves i want;

* this program pulls together health care utilization variables;

* variables are: nursing home days, hospital days, doctor visits, dentist visits, outpatient surgery, whether the respondent didn't take medication; 
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";

*global folder "\\ad.ucl.ac.uk\homer\zctpmer\downloads";
* set this to 1 if include 2020 wave;
global INCLUDE2020 1;
*global folder "C:\research";
global folder "D:\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "~/";

         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
	 	 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";


log using `saved'healutil.log, replace;



**************** WAVE 1*****************;

clear;

set memory 300m;

use `wave1d'Health;

gen hosp1=V535; * hospital days;

*********************************

NOTE: This is hospital days in the "last year", instead of the "last two years" for the other waves;

replace hosp1=0 if V533==5; * inapplicable case;

* replace hosp1=0 if hosp1==.; * missing value case, only 7 cases.

From the codebook, I don't know why it is missing, so I don't recode it.;

replace hosp1=. if hosp1>365;

gen nursing1=V538; * nursing home days;

************************************

NOTE: This is nursing home days in the "last year", instead of the "last two years" for the other waves;

replace nursing1=0 if V536==5; * inapplicable cases;

replace nursing1=0 if nursing1==.; * No such "missing value" cases.;

replace nursing1=. if nursing1>365;

gen drtimes1=V539; *doctor visit times; * no missing value for this variable;

**************************************

NOTE: This is doctor visit times in the "last year", instead of the "last two years" for the other waves;

replace drtimes1=. if drtimes1>365;

gen outsurg1=.; * outpatient surgery data not available;

gen dentist1=.; * dentist vist data not available;

gen nodrug1=.; * data about less medication than necessary not available;

keep HHID PN hosp1 nursing1 drtimes1 outsurg1 dentist1 nodrug1;

summ;

sort HHID PN;

sleep 500; save `saved'healutil  , replace; 

drop _all;













********** WAVE 2 **********; 

use `wave2d'w2b;

*gen subhhid=W2SUBHH; * do I need this?;

************************************

comment: I think we don't need to use W2SUBHH, since it is a wave specific

variable, not across waves;



gen hosp2=W412; * hospital days;

* replace hosp2=0 if W410==.|W410==0; * nullify this statement, since it is useless: 0 changes maded;

replace hosp2=0 if W410==5|W410==8|W410==9|W411==0|W411==998|W411==999;

replace hosp2=. if hosp2>996|W413==8|W413==9;

replace hosp2=hosp2*7 if W413==2;

replace hosp2=hosp2*30 if W413==3;

* note: there are about 124 our of about 2000 observations where W413==8 (DK) which is disturbing,

since we don't know whether the time period is night, week or month;

* Note: no W413==7, "other period", which is good;

replace hosp2=730 if (hosp2>730 & hosp2~=.);



gen nursing2=W417; *nights in nursing home; 

* these numbers seem low vis a vis wave 4 numbers; 

* replace nursing2=0 if W415==. | W415==0; * nullify this statement, since it is useless: 0 changes maded;

replace nursing2=0 if W415==5|W415==8|W415==9|W416==0|W416==998|W416==999;

replace nursing2=. if nursing2>996|W418==8|W418==9; 

* note: no W418=7, "other period", which is good;

replace nursing2=nursing2*7 if W418==2;

replace nursing2=nursing2*30 if W418==3;

* note: there are only 3 out of about 11,590 observations where W418==8, which is not so bad, although 

we don't know about 3 observations whether the time periods are night, week, or month;

replace nursing2=730 if (nursing2>730 & nursing2~=.);



gen drtimes2=W420;

replace drtimes2=. if drtimes2>996;

replace drtimes2=730 if (drtimes2>730 & drtimes2~=.);



gen outsurg2=W391; *note: W391 also includes inpatient surgery;

replace outsurg2=0 if W391~=1;



gen dentist2=.; * no data about dentist2 for wave2;

gen nodrug2=.;  * no data about nodrug2 for wave2;



* no dentist and no "no drug" measure ;

drop W*;



summ;

sort HHID PN; 

merge HHID PN using `saved'healutil;

drop _merge;

destring HHID, replace;
destring PN, replace;
sort HHID PN;

sleep 500; save `saved'healutil, replace; 

clear;



********* WAVE 3 **********;

* Note: The following file `wave3d'w3e Eric sent me is not compatible with the code book. I think it is dangerous to use those w3*.dta files. 

* note : in this wave, I can't differentiate between "inappliable case" and "partial interview" case.

Therefore, for most part of the programming for this wave, I will recode "partial interview" cases as 0 value, unless explictly explained;





*use `wave3d'w3e; * the file is not compatible with the codebook, I will use the file I downloaded directly from the hrs website;

use `wave3d'H96e_r;





gen temp=real(HHID);

drop HHID;


rename temp HHID;

gen temp=real(PN);

drop PN;

rename temp PN;



gen hosp3=E1772; * hospital days;

replace hosp3=0 if E1772==.;

replace hosp3=. if hosp3>996;

replace hosp3=730 if (hosp3>730 & hosp3~=.);



gen nursing3=E1778; *nights in nursing home;

replace nursing3=0 if E1778==.;

replace nursing3=. if nursing3>996;

replace E1779=. if E1779> 48; * question?????: how can there be more than 24 months in the last 2 years?;

* Note: here E1779>48 is a good qualification according to the codebook, although there can't be more than 24 months in the last two years;

replace nursing3=E1779*30 if (nursing3==.|nursing3==0) & E1779~=.;

replace nursing3=730 if (nursing3>730 & nursing3~=.);



gen drtimes3=E1790;

* replace drtimes=0 if E1790==.; * this is not a good statement since all the missing values are well justified

 as missing values because they are all for "partial interview" cases;

replace drtimes3=. if drtimes3>996; *topcoded lower than most years;

*replace drtimes3=730 if (drtimes3>730 & drtimes3~=.);



gen outsurg3=E1795; 

replace outsurg3=0 if E1795~=1;

replace outsurg3=. if E1795==.; * The missing values are justified, since all are for "partial interview" cases;

replace outsurg3=. if E1795==9; * This is for "refused case";

replace outsurg3=. if E1795==7; * this is for "other" case, the meaning of which is not well-documented;

* note: "DK(don't know" and "NA (not ascertained )" cases are assumed to be "no", since it is highly possible that nothing

happened;

gen dentist3=E1800;

replace dentist3=0 if dentist3~=1;

replace dentist3=. if E1800==.; * The missing values are justified, since all are for "partial interview" cases;

replace dentist3=. if E1800==9; * This is for "refused case";

* note: "DK(don't know" and "NA (not ascertained )" cases are assumed to be "no", since it is highly possible that nothing

happened;



gen nodrug3=E1822;

replace nodrug3=0 if nodrug3~=1;

replace nodrug3=. if E1822==.; * The missing values are justified, since all are for "partial interview" cases;

replace nodrug3=. if E1822==9; * This is for "refused case";

* note: "DK(don't know" and "NA (not ascertained )" cases are assumed to be "no", since it is highly possible that nothing

happened;





keep HHID PN nursing3 hosp3 drtimes3 outsurg3 dentist3 nodrug3;

sort HHID PN;

merge HHID PN using `saved'healutil;

drop _merge;

sort HHID PN;

sleep 500; save `saved'healutil, replace; 





********* WAVE 4 *********;

clear;

set memory 300m;

use `wave4d'H98E_R.DTA; * get health care data from this file;

renpfix F Q;

sort HHID DSUBHH;

save `saved'temp, replace; 

clear;

set memory 300m;

use `wave4d'H98CS_R.DTA; * get cover screen data from this file;

renpfix F Q;

sort HHID DSUBHH;

merge HHID DSUBHH using `saved'temp;

gen temp=real(HHID);

drop HHID;

rename temp HHID;

gen temp=real(PN);

drop PN;

rename temp PN;



gen hosp4=Q2297;

replace hosp4=0 if Q2295~=1|Q517==1;  

replace hosp4=0 if hosp4==.; * 0 change made for this statement;

replace hosp4=. if hosp4>996;

replace hosp4=730 if (hosp4>730 & hosp4~=.);



gen nursing4=Q2301; *nights in nursing home;

replace nursing4=0 if Q2299~=1|Q517==1;

* replace nursing4=0 if nursing4==.; * 55 missing values here, but I don't recode them because from

the codebook I can't see why they are missing ;

replace nursing4=. if nursing4>996 & nursing4~=.;

replace Q2302=. if Q2302>96; * question??????: How can there be more than 24 months in the last two years?;

* Note: Q2302>96 is a good qualifier according to the codebook, although there can't be more than 24 months in the last two years;

replace nursing4=Q2302*30 if (nursing4==.|nursing4==0) & Q2302~=.; *months in a nursing home;

replace nursing4=730 if (nursing4>730 & nursing4~=.);



gen drtimes4=Q2331;

* Note : there are 20 missing values of Q2331. But from the codebook, I don't know why they are missing. 

Therefore, i don't recode them;

replace drtimes4=. if drtimes4>996;

replace drtimes4=730 if (drtimes4>730 & drtimes4~=.);



gen outsurg4=Q2333;

replace outsurg4=0 if Q2333~=1;

replace outsurg4=. if Q2333==9; * "refusal" case is treated as missing values;

* note: "DK(don't know)" case is treated as "no";

gen dentist4=Q2335;

replace dentist4=0 if Q2335~=1;

replace dentist4=. if Q2335==9; * "refusal" case is treated as missing values;

* note: "DK(don't know)" case is treated as "no";





gen nodrug4=Q2355;

replace nodrug4=0 if Q2355~=1;

replace nodrug4=. if Q2355==9; * "refusal" case is treated as missing values;

* note: "DK(don't know)" case is treated as "no";







keep HHID PN nursing4 hosp4 drtimes4 outsurg4 dentist4 nodrug4;

sort HHID PN;

merge HHID PN using `saved'healutil;

drop _merge;

sort HHID PN;

sleep 500; save `saved'healutil, replace;





********* WAVE 5 *********;

*use `wave5d'h00_e;
use `wave5d'H00E_R;



gen temp=real(HHID);

drop HHID;

rename temp HHID;

gen temp=real(PN);

drop PN;

rename temp PN;



gen hosp5=G2569;

replace hosp5=0 if G2567~=1;  

replace hosp5=0 if G2569==.; * 0 change made for this statement;

replace hosp5=. if hosp5>996;

replace hosp5=730 if (hosp5>730 & hosp5~=.);



gen nursing5=G2573; *nights in nursing home;


sum nursing5;

replace nursing5=0 if G2571~=1;

sum nursing5;


* replace nursing5=0 if nursing5==.; * 225 missing values here, but I don't recode them because

from the codebook I can't see why they are missing;

replace nursing5=. if nursing5>996 & nursing5~=.;

sum nursing5;

replace G2574=. if G2574>96; * question?????: How can there be more than 24 months in the past 2 years;

sum nursing5;

replace nursing5=G2574*30 if (nursing5==.|nursing5==0) & G2574~=.; *months in a nursing home;

sum nursing5;

replace nursing5=730 if (nursing5>730 & nursing5~=.);



sum nursing5;



gen drtimes5=G2603; 

replace drtimes5=. if drtimes5>996 & drtimes~=.;

replace drtimes5=20 if G2604==3;

replace drtimes5=. if G2604==8|G2604==9; * 0 change made for this statement;

replace drtimes5=5 if G2605==3|G2605==8|G2605==9;

replace drtimes5=13 if G2605==5;

replace drtimes5=3 if G2606==1;

replace drtimes5=0 if G2606==5|G2606==8; * less than 1 time and " DK" case;

replace drtimes5=1 if G2606==9; * "RF(refuse)" case;

replace drtimes5=50 if G2607==3|G2607==8|G2607==9;

replace drtimes5=100 if G2607==5;

replace drtimes5=35 if G2607==1;

replace drtimes5=730 if (drtimes5>730 & drtimes5~=.);



gen outsurg5=G2610;

replace outsurg5=0 if G2610~=1;

replace outsurg5=. if G2610==9; * "refusal" case is treated as missing values;

* note: "DK(don't know)" case is treated as "no";



gen dentist5=G2612;

replace dentist5=0 if G2612~=1;

replace dentist5=. if G2612==9; * "refusal" case is treated as missing values;

* note: "DK(don't know)" case is treated as "no";



gen nodrug5=G2632;

replace nodrug5=0 if G2632~=1;

replace nodrug5=. if G2632==9; * "refusal" case is treated as missing values;

* note: "DK(don't know)" case is treated as "no";




keep HHID PN nursing5 hosp5 drtimes5 outsurg5 dentist5 nodrug5;

sort HHID PN;

merge HHID PN using `saved'healutil;

drop _merge;

sort HHID PN;

sleep 500; save `saved'healutil, replace;



***************************** AHEAD WAVE I **********************************;

clear;

set memory 300m;

use `aheadw1'bhh21;

sort HHID BSUBHH;

save `aheadw1'temp, replace;

clear;

set memory 300m;

use `aheadw1'br21;

sort HHID BSUBHH;

merge HHID BSUBHH using `aheadw1'temp;

drop _merge;




gen hosp1=V607; * hospital days;

*********************************

NOTE: This is hospital days in the "last year", instead of the "last two years" for the other waves;

replace hosp1=0 if V605R==5;

replace hosp1=0 if V605R==.; * 1 "DK" case and 1 "NA" case, where for "NA" case the re-coding is not justified;  

* replace hosp1=0 if hosp1==.; *  About 21 missing values would be changed to 0;

* note: This re-coding statement would not be well justified, since they are missing values

well justified because of "DK ( don't know )" or "RF(refuse)";

replace hosp1=. if hosp1>365;

gen nursing1=V624; * nursing home days;

************************************

NOTE: This is nursing home days in the "last year", instead of the "last two years" for the other waves;

replace nursing1=0 if V622R==5;

replace nursing1=. if V622R==.; * 1 "NA" cases;

* replace nursing1=0 if nursing1==.; * about 8 missing values would be changed to 0;

* note: This re-coding statement would not be well justified, since they are missing values

well justified because of "DK ( don't know )" or "RF(refuse)";

replace nursing1=. if nursing1>365;

gen drtimes1=V640; *doctor visit times;

**************************************

NOTE: This is doctor visit times in the "last year", instead of the "last two years" for the other waves;

replace drtimes1=0 if V639R==5;

replace drtimes1=0 if V639R==.; * 8 "DK" cases, 1 "RF" case and 1 "NA" case, where re-coding for the later two cases

are not justified;

* replace drtimes1=0 if drtimes1==.; * about 120 missing values would be changed to 0;

* note: This re-coding statement would not be well justified, since they are missing values

well justified because of "DK ( don't know )" or "RF(refuse)";



replace drtimes1=. if drtimes1>365;

gen outsurg1=V654R; * respondent's outpatient surgery;

***************************************************

NOTE: There is another variable v654, which refers to "respondent's or spouse's outpatient surgery".

Here I use v654R, but I don't know which one is better for our purpose;

*****************************************************************

NOTE: This variable is about the "last year", instead of the "last two years" for other waves;

replace outsurg1=0 if outsurg1~=1; * 1 "NA" case where the missing value is changed to 0;

gen dentist1=V669R; * dentist visit or not;

*************************************************

NOTE: There is another variable V669, which refers to "respondent's or spouse's dentist visit" or not.

Here I use V669R, but I don't know which one is better for our purpose;

*****************************************************************

NOTE: This variable is about the "last year", instead of the "last two years" for other waves;

replace dentist=0 if dentist~=1; * 1 "NA" case where the missing value is changed to 0;

gen nodrug1=V680; * less medication than necessary or not ;

*****************************************************************

NOTE: This variable is about the "last year", instead of the "last two years" for other waves;

replace nodrug1=0 if nodrug1~=1; * 2 "RF" cases and 1 "NA" case where the missing values are changed to 0;

keep HHID PN hosp1 nursing1 drtimes1 outsurg1 dentist1 nodrug1;

summ;


gen temp=real(HHID);

drop HHID;

rename temp HHID;

gen temp=real(PN);

drop PN;

rename temp PN;

sort HHID PN;

save `aheadw1'healutil, replace; 

clear;







*****************************   AHEAD WAVE II ******************************;



clear;

set memory 300m;

use `aheadw2'A95E_R;

gen temp=real(HHID);

drop HHID;

rename temp HHID;

gen temp=real(PN);

drop PN;

rename temp PN;


gen hosp2=D1666; * hospital days;

replace hosp2=0 if D1664==5|D1664==8; * " DK" assumed to be "no";

replace hosp2=. if D1664==9; * "RF" case;

* replace hosp2=0 if hosp2==.; * this is not a well justified statement;

replace hosp2=. if hosp2>996;

replace hosp2=730 if (hosp2>730 & hosp2~=.);



gen nursing2=D1683; *nights in nursing home; 

replace nursing2=0 if D1681~=1; * including all "inapplicable" cases;

* replace nursing2=0 if nursing2==.; * this is not a justified statement;

replace nursing2=. if nursing2>996;

replace D1684=. if D1684>96;

replace nursing2=D1684*30 if D1684~=.;

replace nursing2=730 if (nursing2>730 & nursing2~=.);



gen drtimes2=D1698; * doctor times;



replace drtimes2=0 if drtimes2==.; * 0 change made;

replace drtimes2=. if drtimes2>996;

replace drtimes2=730 if (drtimes2>730 & drtimes2~=.);



gen outsurg2=D1713; *having outpatient surgery or not;

replace outsurg2=0 if D1713~=1; * no "RF" case, only "inapplicable" case and so on, "DK" assumed to be "no";



gen dentist2=D1728; * seeing dentist or not;

replace dentist2=0 if dentist2~=1; * no "RF" case, only "inapplicable" case and so on, "DK" assumed to be "no";



*********************************

NOTE: We also let the values of the cases where this question doesn't apply be 0, 

which may be too much. We did this for all dummy variables in healutil.do files;

gen nodrug2=D1755;  * having less medication than necessary or not;

replace nodrug2=0 if nodrug2~=1; * no "RF" case, only "inapplicable" case and so on, "DK" assumed to be "no";

keep HHID PN hosp2 nursing2 drtimes2 outsurg2 dentist2 nodrug2;

summ;

sort HHID PN;

merge HHID PN using `aheadw1'healutil;

drop _merge;





***************** Merge ahead data to HRS data *************************;



* rename AHEAD variables for merging;

rename hosp1 ahosp1;

rename nursing1 anursin1;

rename drtimes1 adrtime1;

rename outsurg1 aoutsur1;

rename dentist1 adentis1;

rename nodrug1 anodrug1;

rename hosp2 ahosp2;

rename nursing2 anursin2;

rename drtimes2 adrtime2;

rename outsurg2 aoutsur2;

rename dentist2 adentis2;

rename nodrug2 anodrug2;

summ;


sort HHID PN;


save `aheadw2'healutil, replace; 





* merge the AHEAD healutil.dta file to the HRS healutil.dta file here;
clear;


set mem 300m;


use `saved'healutil;


sort HHID PN;


merge HHID PN using `aheadw2'healutil;


drop _merge;



* replace missing HRS WAVE I and WAVE II values with AHEAD WAVE I and WAVE II 

values;

replace hosp1=ahosp1 if hosp1==. & ahosp1~=.;

replace nursing1=anursin1 if nursing1==. & anursin1~=.;

replace drtimes1=adrtime1 if drtimes1==. & adrtime1~=.;

replace outsurg1=aoutsur1 if outsurg1==. & aoutsur1~=.;

replace dentist1=adentis1 if dentist1==. & adentis1~=.;

replace nodrug1=anodrug1 if nodrug1==. & anodrug1~=.;

replace hosp2=ahosp2 if hosp2==. & ahosp2~=.;

replace nursing2=anursin2 if nursing2==. & anursin2~=.;

replace drtimes2=adrtime2 if drtimes2==. & adrtime2~=.;

replace outsurg2=aoutsur2 if outsurg2==. & aoutsur2~=.;

replace dentist2=adentis2 if dentist2==. & adentis2~=.;

replace nodrug2=anodrug2 if nodrug2==. & anodrug2~=.;


* annualize some variables - for AHEAD people in 1998, should this be per two years or three, since they were last interviewed in 1995;


replace hosp2=hosp2/2;
replace nursing2=nursing2/2;	
replace drtimes2=drtimes2/2;
replace outsurg2=outsurg2/2;

replace hosp3=hosp3/2;
replace nursing3=nursing3/2;	
replace drtimes3=drtimes3/2;
replace outsurg3=outsurg3/2;

replace hosp4=hosp4/2;
replace nursing4=nursing4/2;	
replace drtimes4=drtimes4/2;
replace outsurg4=outsurg4/2;

replace hosp5=hosp5/2;
replace nursing5=nursing5/2;	
replace drtimes5=drtimes5/2;
replace outsurg5=outsurg5/2;

drop a*; * drop AHEAD variables;




sort HHID PN;


sleep 500; save `saved'healutil, replace;


summ;


drop _all;

clear;


********* WAVE 6 **********;

use `wave6d'H02N_r, clear;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;

gen hosp6=.;
gen nursing6=.;
gen drtimes6=.;
gen outsurg6=.;
gen dentist6=.;

gen nodrug6=0;
replace nodrug6=1 if HN188==1;
replace nodrug6=. if HN188==9|HN188==.;

keep HHID PN nursing6 hosp6 drtimes6 outsurg6 dentist6 nodrug6;
sort HHID PN;
merge HHID PN using `saved'healutil;
drop _merge;
sort HHID PN;
sleep 500; save `saved'healutil, replace;


********* WAVE 7 **********;

use `wave7d'H04N_r, clear;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;

gen hosp7=.;
gen nursing7=.;
gen drtimes7=.;
gen outsurg7=.;
gen dentist7=.;

gen nodrug7=0;
replace nodrug7=1 if JN188==1;
replace nodrug7=. if JN188==9|JN188==.;

keep HHID PN nursing7 hosp7 drtimes7 outsurg7 dentist7 nodrug7;
sort HHID PN;
merge HHID PN using `saved'healutil;
drop _merge;
sort HHID PN;
sleep 500; save `saved'healutil, replace;


********* WAVE 8 **********;

use `wave8d'H06N_r, clear;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;

gen hosp8=.;
gen nursing8=.;
gen drtimes8=.;
gen outsurg8=.;
gen dentist8=.;

gen nodrug8=0;
replace nodrug8=1 if KN188==1;
replace nodrug8=. if KN188==9|KN188==.;

keep HHID PN nursing8 hosp8 drtimes8 outsurg8 dentist8 nodrug8;
sort HHID PN;
merge HHID PN using `saved'healutil;
drop _merge;
sort HHID PN;
sleep 500; save `saved'healutil, replace;


********* WAVE 9 **********;

use `wave9d'H08N_r, clear;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;

gen hosp9=.;
gen nursing9=.;
gen drtimes9=.;
gen outsurg9=.;
gen dentist9=.;

gen nodrug9=0;
replace nodrug9=1 if LN188==1;
replace nodrug9=. if LN188==9|LN188==.;

keep HHID PN nursing9 hosp9 drtimes9 outsurg9 dentist9 nodrug9;
sort HHID PN;
merge HHID PN using `saved'healutil;
drop _merge;
sort HHID PN;
sleep 500; save `saved'healutil, replace;


********* WAVE 10 **********;

use `wave10d'H10N_r, clear;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;

gen hosp10=.;
gen nursing10=.;
gen drtimes10=.;
gen outsurg10=.;
gen dentist10=.;

gen nodrug10=0;
replace nodrug10=1 if MN188==1;
replace nodrug10=. if MN188==9|MN188==.;

keep HHID PN nursing10 hosp10 drtimes10 outsurg10 dentist10 nodrug10;
sort HHID PN;
merge HHID PN using `saved'healutil;
drop _merge;
sort HHID PN;
sleep 500; save `saved'healutil, replace;


********* WAVE 11 **********;

use `wave11d'H12N_r, clear;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;

gen hosp11=.;
gen nursing11=.;
gen drtimes11=.;
gen outsurg11=.;
gen dentist11=.;

gen nodrug11=0;
replace nodrug11=1 if NN188==1;
replace nodrug11=. if NN188==9|NN188==.;

keep HHID PN nursing11 hosp11 drtimes11 outsurg11 dentist11 nodrug11;
sort HHID PN;
merge HHID PN using `saved'healutil;
drop _merge;
sort HHID PN;
sleep 500; save `saved'healutil, replace;

***************** Wave 12 ******************;
use `wave12d'H14N_R, clear;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;

gen hosp12=.;
gen nursing12=.;
gen drtimes12=.;
gen outsurg12=.;
gen dentist12=.;

gen nodrug12=0;
replace nodrug12=1 if ON188==1;
replace nodrug12=. if ON188==9|ON188==.;

keep HHID PN nursing12 hosp12 drtimes12 outsurg12 dentist12 nodrug12;
sort HHID PN;
merge HHID PN using `saved'healutil;
drop _merge;
sort HHID PN;
sleep 500; save `saved'healutil, replace;

***************** Wave 13 ******************;
use `wave13d'H16N_R, clear;
gen temp=real(HHID);
drop HHID;
rename temp HHID;
gen temp=real(PN);
drop PN;
rename temp PN;

gen hosp13=.;
gen nursing13=.;
gen drtimes13=.;
gen outsurg13=.;
gen dentist13=.;

gen nodrug13=0;
replace nodrug13=1 if PN188==1;
replace nodrug13=. if PN188==9|PN188==.;

keep HHID PN nursing13 hosp13 drtimes13 outsurg13 dentist13 nodrug13;
sort HHID PN;
merge HHID PN using `saved'healutil;
drop _merge;
sort HHID PN;
sleep 500; save `saved'healutil, replace;

***************** Wave 14 ******************;
use `wave14d'H18N_R, clear;
gen temp=real(hhid);
drop hhid;
rename temp HHID;
gen temp=real(pn);
drop pn;
rename temp PN;

gen hosp14=.;
gen nursing14=.;
gen drtimes14=.;
gen outsurg14=.;
gen dentist14=.;

gen nodrug14=0;
replace nodrug14=1 if QN188==1;
replace nodrug14=. if QN188==9|QN188==.;

keep HHID PN nursing14 hosp14 drtimes14 outsurg14 dentist14 nodrug14;
sort HHID PN;
merge HHID PN using `saved'healutil;
drop _merge;
sort HHID PN;
sleep 500; save `saved'healutil, replace;

if $INCLUDE2020 {; 
disp "Doing 2020 processing..." ;
***************** Wave 15 ******************;
use `wave15d'H20N_R, clear;
gen temp=real(hhid);
drop hhid;
rename temp HHID;
gen temp=real(pn);
drop pn;
rename temp PN;


gen hosp15=.;
gen nursing15=.;
gen drtimes15=.;
gen outsurg15=.;
gen dentist15=.;

gen nodrug15=0;
replace nodrug15=1 if RN188==1;
replace nodrug15=. if RN188==9|RN188==.;

keep HHID PN nursing15 hosp15 drtimes15 outsurg15 dentist15 nodrug15;
sort HHID PN;
merge HHID PN using `saved'healutil;
drop _merge;
sort HHID PN;
sleep 500; save `saved'healutil, replace;
};

// drop _all;

cap log close;

* compare summary stats before and after;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(healutil.xlsx) replace;
cd "$folder\hrs\merge\" ;
use `saved'healutil.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(healutil.xlsx) sheetname(Old);











